<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if the method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Read the raw POST data
    $rawData = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($rawData, true);

    // Check for errors in JSON decoding
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    // Check for required fields
    if (!isset($data['name'])) {
        echo json_encode(['status' => 'error', 'message' => 'Required fields are missing']);
        exit();
    }

    // Sanitize and assign data to variables
    $categoryID = isset($data['categoryid']) ? $conn->real_escape_string($data['categoryid']) : null;
    $name = $conn->real_escape_string($data['name']);
    $image = isset($data['image']) ? $conn->real_escape_string($data['image']) : null;
    $urlslug = $conn->real_escape_string($data['urlslug']);
    $gmccategory = $conn->real_escape_string($data['gmccategory']);
    $seotitle = $conn->real_escape_string($data['seotitle']);
    $seodescription = $conn->real_escape_string($data['description']);
    $createdAt = date('Y-m-d H:i:s');
    $deleteStatus = 0;

    if ($categoryID) {
        // Update existing category
        $sql = "UPDATE categories SET 
                    name = '$name', 
                    gmccategorg = '$gmccategory', 
                    urlslug = '$urlslug', 
                    seotitle = '$seotitle', 
                    seodescription = '$seodescription', 
                    Create_at = '$createdAt', 
                    Delete_status = '$deleteStatus'";
        if ($image) {
            $sql .= ", image = '$image'";
        }
        $sql .= " WHERE category_ID = '$categoryID'";
    } else {
        // Insert new category
        $sql = "INSERT INTO categories (name, image, gmccategorg, urlslug, seotitle, seodescription, Create_at, Delete_status) 
                VALUES ('$name', '$image', '$gmccategory', '$urlslug', '$seotitle', '$seodescription', '$createdAt', '$deleteStatus')";
    }

    // Execute the query
    if ($conn->query($sql) === TRUE) {
        if ($categoryID) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Category updated successfully',
                'data' => [
                    'category_ID' => $categoryID,
                    'name' => $name,
                    'image' => $image,
                    'Create_at' => $createdAt,
                    'Delete_status' => $deleteStatus
                ]
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'message' => 'Category added successfully',
                'data' => [
                    'category_ID' => $conn->insert_id,
                    'name' => $name,
                    'image' => $image,
                    'Create_at' => $createdAt,
                    'Delete_status' => $deleteStatus
                ]
            ]);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Query execution failed', 'error_detail' => $conn->error]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
